import { LoaderParserPriority, checkExtension, createTexture } from "@pixi/assets";
import { CompressedTextureResource } from "@pixi/compressed-textures";
import { ExtensionType, settings, FORMATS, BaseTexture, MIPMAP_MODES, ALPHA_MODES, extensions } from "@pixi/core";
import { BASIS_FORMAT_TO_TYPE, BASIS_FORMATS } from "../Basis.mjs";
import { TranscoderWorker } from "../TranscoderWorker.mjs";
import { BasisParser } from "./BasisParser.mjs";
const loadBasis = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.High
  },
  name: "loadBasis",
  test(url) {
    return checkExtension(url, ".basis");
  },
  async load(url, asset, loader) {
    await TranscoderWorker.onTranscoderInitialized;
    const arrayBuffer = await (await settings.ADAPTER.fetch(url)).arrayBuffer(), resources = await BasisParser.transcode(arrayBuffer), type = BASIS_FORMAT_TO_TYPE[resources.basisFormat], format = resources.basisFormat !== BASIS_FORMATS.cTFRGBA32 ? FORMATS.RGB : FORMATS.RGBA, textures = resources.map((resource) => {
      const base = new BaseTexture(resource, {
        mipmap: resource instanceof CompressedTextureResource && resource.levels > 1 ? MIPMAP_MODES.ON_MANUAL : MIPMAP_MODES.OFF,
        alphaMode: ALPHA_MODES.NO_PREMULTIPLIED_ALPHA,
        type,
        format,
        ...asset.data
      });
      return createTexture(base, loader, url);
    });
    return textures.length === 1 ? textures[0] : textures;
  },
  unload(texture) {
    Array.isArray(texture) ? texture.forEach((t) => t.destroy(!0)) : texture.destroy(!0);
  }
};
extensions.add(loadBasis);
export {
  loadBasis
};
//# sourceMappingURL=loadBasis.mjs.map
